TITLE   'Field around Two Wires' 					{ exa122.pde }
SELECT    errlim=3e-4     ngrid=1     spectral_colors	
VARIABLES   Az
DEFINITIONS                      				
   r0=0.05     d0=0.2     r1=1.0
   mu0=4*pi*1e-7     mu=mu0     Jz     			{ Current density }
   Bex=dy(Az)     Bey=-dx(Az)
   B=vector( Bex, Bey)     Bm=magnitude( B)
   Hx=Bex/mu     Hy=Bey/mu     H=B/mu     Hm=Bm/mu	
EQUATIONS
   dx( Hy)- dy( Hx)=Jz
BOUNDARIES
region 'domain'  Jz=0       	
   start(-r1,0)   value(Az) =0   arc(center=0,0) angle=360
region 'lower' Jz=  -1.0	
   start (r0,-d0/2)  arc(center=0,-d0/2)  angle=360
region 'upper' Jz= +1.0
   start (r0,d0/2) arc(center=0,d0/2)  angle=360
PLOTS
   contour( Bm) log     vector( B) norm
   contour( Bm) painted zoom(-d0,-d0,  2*d0,2*d0)
   elevation( Bm) from (0,-r1) to (0,r1)
   vector( B) norm zoom(-d0,-d0,  2*d0,2*d0)
END

